format long g

equilibrium = csvread('station_equilibrium.csv');
utilities = csvread('station_investor_utilities.csv');
drivers = csvread('driver_equilibrium.csv');
queues = csvread('expected_queueing_time.csv');
runtime = csvread('runtimes.csv');
cent = csvread('centralised.csv');
newEquilibrium = equilibrium;
newUtilities = utilities;
newQueues = queues;
newDrivers = drivers;
maxW = csvread('maximum_welfare.csv');


w = 2190;
limit = 148;



%swap equilibrium
for i = 1:limit
    if equilibrium(i, 2) < equilibrium(i, 3)
        newEquilibrium(i, 2) = equilibrium(i, 3);
        newEquilibrium(i, 3) = equilibrium(i, 2);
        newEquilibrium(i, 4) = equilibrium(i, 5);
        newEquilibrium(i, 5) = equilibrium(i, 4);
        newEquilibrium(i, 6) = equilibrium(i, 7);
        newEquilibrium(i, 7) = equilibrium(i, 6);
        newUtilities(i, 2) = utilities(i, 3);
        newUtilities(i, 3) = utilities(i, 2);
        newUtilities(i, 4) = utilities(i, 5);
        newUtilities(i, 5) = utilities(i, 4);
        newQueues(i, 2) = queues(i, 3);
        newQueues(i, 3) = queues(i, 2);
        newDrivers(i, 2) = drivers(i, 3);
        newDrivers(i, 3) = drivers(i, 2);
        newDrivers(i, 5) = drivers(i, 6);
        newDrivers(i, 6) = drivers(i, 5);
    end
end

%for multiple locations
for i = 1:limit
    if equilibrium(i, 3) < equilibrium(i, 5)
        newEquilibrium(i, 3) = equilibrium(i, 5);
        newEquilibrium(i, 5) = equilibrium(i, 3);
        newEquilibrium(i, 7) = equilibrium(i, 9);
        newEquilibrium(i, 9) = equilibrium(i, 7);
       
    end
end
        newUtilities(i, 6) = utilities(i, 7);
        newUtilities(i, 7) = utilities(i, 6);
        newQueues(i, 2) = queues(i, 4);
        newQueues(i, 4) = queues(i, 2);
    end
end


%Write adjusted files
csvwrite('A_station_equilibrium.csv', newEquilibrium);
csvwrite('A_station_investor_utilities.csv', newUtilities);
csvwrite('A_expected_queueing_time.csv', newQueues);
csvwrite('A_driver_equilibrium.csv', newDrivers);

products(:, 1) = newDrivers(:, 2).*newQueues(:, 2)
products(:, 2) = newDrivers(:, 3).*newQueues(:, 3)
averageQueue = products(:, 1)+products(:, 2)


%Capacity subsidy efficiency
totalCapacity = zeros(size(newE, 1), 1);
for i = 1:size(newE, 1)
    if newE(i, 6) == 2
        totalCapacity(i) = totalCapacity(i) + newE(i, 2);
    end
    if newE(i, 7) == 2
        totalCapacity(i) = totalCapacity(i) + newE(i, 3);
    end
end
totalCapacity = newEquilibrium(:, 2)+ newEquilibrium(:, 3)
totalCost = subsidy.*totalCapacity

investorGain = newU(:, 6) - newU(1, 6)
driverGain = newD(:, 8) - newD(1, 8)
driverGain = driverGain.*norm*30

driverRatio = driverGain./totalCost
investorRatio = investorGain./totalCost

toPlot(1,:) = newEquilibrium(1, :)
for i = 1:59
    toPlot(i, :) = newEquilibrium(i*2, :);
end

%capacity subsidy
x = newEquilibrium(:, 1);
caps = newEquilibrium(:,5);
su = newUtilities(:, 8);
du = newDrivers(:,12);
n = 30;
norm = 2190;
totalCost = caps.*x;

driverDiff = zeros(length(x),1);
stationDiff = zeros(length(x),1);
for i = 1:length(x)
    driverDiff(i) = du(i)-du(1);
    stationDiff(i) = su(i)-su(1);
end

driverDiff = driverDiff.*(n*norm);

stationRatio = stationDiff./totalCost;
driverRatio = driverDiff./totalCost;
totalRatio = stationRatio+driverRatio;

%kwh subsidy
x = newEquilibrium(1:2:101, 1);
caps = newEquilibrium(1:2:101, 2)+newEquilibrium(1:2:101,3);
su = newUtilities(1:2:101, 6);
du = newDrivers(1:2:101,8);
n = 60;
norm = 2190;
totalCost = (24/0.85).*x
totalCost = totalCost.*(newDrivers(1:2:101,2)+newDrivers(1:2:101,3))*n*norm
driverDiff = zeros(length(x),1);
stationDiff = zeros(length(x),1);
for i = 1:length(x)
    driverDiff(i) = du(i)-du(1);
    stationDiff(i) = su(i)-su(1);
end

driverDiff = driverDiff.*(n*norm);

stationRatio = stationDiff./totalCost;
driverRatio = driverDiff./totalCost;
totalRatio = stationRatio+driverRatio;

%capacity subsidy mult. loc.

x = newEquilibrium(1:5:152, 1);
caps = newEquilibrium(1:5:152, 3)+newEquilibrium(1:5:152,5);
su = newUtilities(1:5:152, 8);
du = newDrivers(1:5:152,12);
n = 30;
norm = 2190;
totalCost = caps.*x;

driverDiff = zeros(length(x),1);
stationDiff = zeros(length(x),1);
for i = 1:length(x)
    driverDiff(i) = du(i)-du(1);
    stationDiff(i) = su(i)-su(1);
end

driverDiff = driverDiff.*(n*norm);

stationRatio = stationDiff./totalCost;
driverRatio = driverDiff./totalCost;
totalRatio = stationRatio+driverRatio;



